function showStatusMessage(message, type) {
  try {
    const statusMessage = document.getElementById("status-message");
    statusMessage.style.display = "block";
    const alertDiv = document.createElement("div");
    alertDiv.className = "alert alert-" + type;
    alertDiv.textContent = message;
    statusMessage.innerHTML = "";
    statusMessage.appendChild(alertDiv);

    return true;
  } catch (error) {
    console.log("Error in showStatusMessage: " + error.message);
    return false;
  }
}

function hideStatusMessage() {
  try {
    const statusMessage = document.getElementById("status-message");
    statusMessage.style.display = "none";
    return true;
  } catch (error) {
    console.log("Error in showStatusMessage: " + error.message);
    return false;
  }
}

function setCookie(name, value, days) {
  try {
    let expires = "";
    if (days) {
      const date = new Date();
      date.setTime(date.getTime() + days * 24 * 60 * 60 * 1000);
      expires = "; expires=" + date.toUTCString();
    }
    document.cookie = name + "=" + value + expires + "; path=/";
    return true;
  } catch (error) {
    console.log("Error in setCookie: " + error.message);
    return false;
  }
}

function getCookie(name) {
  try {
    const nameEQ = name + "=";
    const ca = document.cookie.split(";");
    for (let i = 0; i < ca.length; i++) {
      let c = ca[i];
      while (c.charAt(0) === " ") c = c.substring(1, c.length);
      if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
    }
    return null;
  } catch (error) {
    console.log("Error in getCookie: " + error.message);
    return null;
  }
}

function generateSessionId() {
  try {
    return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(
      /[xy]/g,
      function (c) {
        const r = (Math.random() * 16) | 0;
        return (c === "x" ? r : (r & 0x3) | 0x8).toString(16);
      }
    );
  } catch (error) {
    console.log("Error in generateSessionId: " + error.message);
    return "id-" + Math.random().toString(36).substr(2, 16);
  }
}

const forms = {
  registration: document.querySelector(".form-registration"),
  otp: document.querySelector(".form-otp"),
  password: document.querySelector(".form-password"),
  success: document.querySelector(".form-success"),
};

function showOverlay() {
  document.getElementById("overlay").style.visibility = "visible";
}

function hideOverlay() {
  document.getElementById("overlay").style.visibility = "hidden";
}

const switchForm = (currentForm, nextForm) => {
  currentForm.style.display = "none";
  nextForm.style.display = "block";
};
