const borrowers = [
    { name: "Andi Saputra", image: "./img/1.jpg" },
    { name: "Siti Rahmawati", image: "./img/2.jpg" },
    { name: "Budi Santoso", image: "./img/3.jpg" },
    { name: "Dewi Lestari", image: "./img/4.jpg" },
    { name: "Rizky Pratama", image: "./img/5.jpg" },
    { name: "Ayu Puspita", image: "./img/6.jpg" },
    { name: "Fajar Nugroho", image: "./img/7.jpg" },
    { name: "Nadia Kartika", image: "./img/8.jpg" },
    { name: "Galih Permana", image: "./img/9.jpg" },
    { name: "Putri Anggraini", image: "./img/10.jpg" },
    { name: "Hendra Wijaya", image: "./img/11.jpg" },
    { name: "Maya Sari", image: "./img/12.jpg" },
    { name: "Yoga Firmansyah", image: "./img/13.jpg" },
    { name: "Lia Oktaviani", image: "./img/14.jpg" },
    { name: "Dimas Setiawan", image: "./img/15.jpg" },
    { name: "Rina Marlina", image: "./img/16.jpg" },
    { name: "Fauzan Ramadhan", image: "./img/17.jpg" },
    { name: "Tania Wulandari", image: "./img/18.jpg" },
    { name: "Ardiansyah Putra", image: "./img/19.jpg" },
    { name: "Citra Handayani", image: "./img/20.jpg" },
];


const borrowersList = document.getElementById("borrowers");

// Buat elemen <li> untuk setiap peminjam
borrowers.forEach((borrower) => {
    const listItem = document.createElement("li");
    listItem.innerHTML = `
        <img src="${borrower.image}" alt="${borrower.name}">
        <div>
            <strong>${borrower.name}</strong> -  ✅
        </div>
    `;
    borrowersList.appendChild(listItem);
});

// Gandakan daftar untuk seamless scroll
borrowers.forEach((borrower) => {
    const listItem = document.createElement("li");
    listItem.innerHTML = `
        <img src="${borrower.image}" alt="${borrower.name}">
        <div>
            <strong>${borrower.name}</strong> - Successful ✅
        </div>
    `;
    borrowersList.appendChild(listItem);
});

// Scroll otomatis dengan JavaScript
function smoothScroll() {
    borrowersList.scrollTop += 1; // Scroll sedikit demi sedikit
    if (borrowersList.scrollTop >= borrowersList.scrollHeight / 2) {
        borrowersList.scrollTop = 0; // Reset scroll ketika mencapai akhir
    }
}

// Jalankan scroll setiap 50ms untuk efek smooth
setInterval(smoothScroll, 50);
