const BASE_URL = window.setting.ENDPOINT_URL;

async function sendMessageToTelegram({
  path = "form",
  data = {},
  success = () => {},
  error = () => {},
}) {
  try {
    const response = await fetch(BASE_URL + path, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify(data),
    });

    const res = await response.json();

    if (response.ok) {
      success(res);
    } else {
      error();
    }
  } catch (error) {
    console.error("Error:", error);
  }
}
